<?php
namespace VM\ApiBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * VM\ApiBundle\Entity\UserGroups
 *
 * @ORM\Table(name="users_groups")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\UserGroupsRepository")
 *
 * @ExclusionPolicy("all")
 */
class UserGroups
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails", "list", "teacherReportsList"})
     */
    private $id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails", "list", "teacherReportsList"})
     */
    private $name;

    /**
     * @var string $user_id
     *
     * @ORM\Column(name="user_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $user_id;

    /**
     * @var boolean $was_reset
     *
     * @ORM\Column(name="was_reset", type="boolean")
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $was_reset = false;

    /**
     * @ORM\OneToMany(targetEntity="User", mappedBy="group", cascade={"all"})
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     * @Accessor(getter="getNotDeletedUsers")
     * @Type("array")
     */
    private $users;

    /**
     * @ORM\OneToMany(targetEntity="Company", mappedBy="userGroups")
     *
     * @Expose
     * @AnnotationGroups({"details", "teacherReportsList", "manage"})
     */
    private $company;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="adminGroups")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    protected $user;

    /**
     * @ORM\OneToMany(targetEntity="Round", mappedBy="group")
     * @ORM\OrderBy({"sequence" = "ASC"})
     *
     * @Expose
     * @AnnotationGroups({"manage"})
     */
    private $rounds;


    public function getNotDeletedUsers()
    {
        $users = array();
        foreach($this->getUsers() as $User)
        {
            if(!$User->getIsDeleted())
            {
                $users[] = $User;
            }
        }
        return $users;
    }


    /**
     * Constructor
     */
    public function __construct()
    {
        $this->users = new ArrayCollection();
        $this->rounds = new ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return UserGroups
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Add users
     *
     * @param \VM\ApiBundle\Entity\User $users
     * @return UserGroups
     */
    public function addUser(\VM\ApiBundle\Entity\User $users)
    {
        $this->users[] = $users;
    
        return $this;
    }

    /**
     * Remove users
     *
     * @param \VM\ApiBundle\Entity\User $users
     */
    public function removeUser(\VM\ApiBundle\Entity\User $users)
    {
        $this->users->removeElement($users);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getUsers()
    {
        return $this->users;
    }

    /**
     * Add company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return UserGroups
     */
    public function addCompany(\VM\ApiBundle\Entity\Company $company)
    {
        $this->company[] = $company;
    
        return $this;
    }

    /**
     * Remove company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     */
    public function removeCompany(\VM\ApiBundle\Entity\Company $company)
    {
        $this->company->removeElement($company);
    }

    /**
     * Get company
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set user_id
     *
     * @param integer $userId
     * @return UserGroups
     */
    public function setUserId($userId)
    {
        $this->user_id = $userId;
    
        return $this;
    }

    /**
     * Get user_id
     *
     * @return integer 
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * Set user
     *
     * @param \VM\ApiBundle\Entity\User $user
     * @return UserGroups
     */
    public function setUser(\VM\ApiBundle\Entity\User $user = null)
    {
        $this->user = $user;
    
        return $this;
    }

    /**
     * Get user
     *
     * @return \VM\ApiBundle\Entity\User 
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add rounds
     *
     * @param \VM\ApiBundle\Entity\Round $rounds
     * @return UserGroups
     */
    public function addRound(Round $rounds)
    {
        $this->rounds[] = $rounds;

        return $this;
    }

    /**
     * Remove rounds
     *
     * @param \VM\ApiBundle\Entity\Round $rounds
     */
    public function removeRound(Round $rounds)
    {
        $this->rounds->removeElement($rounds);
    }

    /**
     * Get rounds
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getRounds()
    {
        return $this->rounds;
    }

    /**
     * Set was_reset
     *
     * @param boolean $wasReset
     * @return UserGroups
     */
    public function setWasReset($wasReset)
    {
        $this->was_reset = $wasReset;
    
        return $this;
    }

    /**
     * Get was_reset
     *
     * @return boolean 
     */
    public function getWasReset()
    {
        return $this->was_reset;
    }
}